using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using Borland.Eco.Handles;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;

namespace SimpleEcoWebDemo
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class MainForm : System.Web.UI.Page
	{
		protected Borland.Eco.Handles.ReferenceHandle rhRoot;
		private SimpleEcoWebDemoEcoSpace ecoSpace;
		protected Borland.Eco.Handles.ExpressionHandle allOrders;
		protected System.Web.UI.WebControls.DataGrid dataGrid1;
		protected System.Web.UI.WebControls.Button button1;
		protected System.Web.UI.WebControls.Button button2;
		protected SimpleEcoWebDemoEcoSpace EcoSpace
		{
			get
			{
				if (ecoSpace == null)
				{
					ecoSpace = EcoSpaceProvider.GetEcoSpace();
					rhRoot.EcoSpace = ecoSpace;
				}
				return ecoSpace;
			}
		}

		private void DoneWithEcoSpace()
		{
			if (ecoSpace == null)
				return;
			rhRoot.EcoSpace = null;
			rhRoot.SetElement(null);
			// Clear all other references to ecoSpace or it's contents here.
			// Otherwise it is not safe to return it to a pool.
			EcoSpaceProvider.ReturnEcoSpace(ecoSpace);
			ecoSpace = null;
		}
		
		private void Page_Load(object sender, System.EventArgs e)
		{
			EcoSpace.Active = true;
			string Id = Request.Params["RootId"];
			if ((Id != null) && (Id != ""))
				rhRoot.SetElement(ObjectForId(Id));
			if (!IsPostBack)
				DataBind();
			// Put user code to initialize the page here
		}

		private void Page_Unload(object sender, System.EventArgs e)
		{
			DoneWithEcoSpace();
		}

		public override void DataBind()
		{
			ElementHandle.EnsureAllBindingLists();
			base.DataBind();
		}


		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// Required for Web Form Designer support
			//
			InitializeComponent();
			base.OnInit(e);
		}

		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			Borland.Eco.Handles.Column column11 = new Borland.Eco.Handles.Column();
			this.rhRoot = new Borland.Eco.Handles.ReferenceHandle();
			this.allOrders = new Borland.Eco.Handles.ExpressionHandle();
			this.dataGrid1.DeleteCommand += new System.Web.UI.WebControls.DataGridCommandEventHandler(this.DataGrid_DeleteCommand);
			this.button1.Click += new System.EventHandler(this.button1_Click);
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// rhRoot
			// 
			this.rhRoot.AddDefaultNestings = false;
			this.rhRoot.AddDefaultProperties = true;
			this.rhRoot.AddExternalId = false;
			this.rhRoot.EcoSpace = null;
			this.rhRoot.EcoSpaceType = typeof(SimpleEcoWebDemo.SimpleEcoWebDemoEcoSpace);
			this.rhRoot.StaticValueTypeName = "";
			this.rhRoot.Variables = null;
			// 
			// allOrders
			// 
			this.allOrders.AddDefaultNestings = false;
			this.allOrders.AddDefaultProperties = true;
			this.allOrders.AddExternalId = true;
			this.allOrders.AddRootVariables = false;
			column11.EventDerivedValue = false;
			column11.Expression = "self.OrderItem->collect(Price*Quantity)->sum";
			column11.Name = "OrderValue";
			column11.Nested = false;
			column11.NestingName = "";
			this.allOrders.Columns.AddRange(new Borland.Eco.Handles.Column[] {
						column11});
			this.allOrders.Expression = "Order.allInstances";
			this.allOrders.RootHandle = this.rhRoot;
			this.allOrders.Variables = null;
			this.Unload += new System.EventHandler(this.Page_Unload);
			this.Load += new System.EventHandler(this.Page_Load);
		}
		#endregion

		#region Utility methods
		protected void UpdateDatabase()
		{
			IPersistenceService persistenceService = EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
			IDirtyListService dirtyListService = EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
			persistenceService.UpdateDatabaseWithList(dirtyListService.AllDirtyObjects());
		}

		protected string IdForObject(IObject obj)
		{
			IExternalIdService idService = EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
			return idService.IdForObject(obj);
		}

		protected IObject ObjectForId(string id)
		{
			IExternalIdService idService = EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
			return idService.ObjectForId(id);
		}
		#endregion

		#region DataGrid support routines

		/*
		The following code is useful if the form contains a System.Web.UI.Datagrid;
		It assumes that the elementhandle acting as a datasource has
		AddExternalId = true, and that datagrid.DataKeyField = "ExternalId"
		*/

		private void DataGrid_DeleteCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			DataGrid dataGrid = (DataGrid)source;
			string id = dataGrid.DataKeys[e.Item.ItemIndex].ToString();
			IObject toDelete = ObjectForId(id);
			if (toDelete != null)
				toDelete.Delete();
			UpdateDatabase();
			DataBind();
		}

		private void DataGrid_EditCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			((DataGrid)source).EditItemIndex = e.Item.ItemIndex;
			DataBind();
		}

		private void DataGrid_UpdateCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			DataGrid dataGrid = (DataGrid)source;
			dataGrid.DataBind(); // To get DataSource
			ElementHandle eh = (ElementHandle)dataGrid.DataSource;
			string id = dataGrid.DataKeys[e.Item.ItemIndex].ToString();;
			object row = eh.RenderElement(ObjectForId(id));
			for (int colIndex = 0; colIndex <  dataGrid.Columns.Count; colIndex++)
			{
				BoundColumn col = dataGrid.Columns[colIndex] as BoundColumn;
				if ((col != null) && !col.ReadOnly)
					eh.SetRenderedElementProperty(row, col.DataField, ((TextBox)e.Item.Cells[colIndex].Controls[0]).Text, true);
			}
			UpdateDatabase();
			dataGrid.EditItemIndex = -1;
			DataBind();
		}

		private void DataGrid_CancelCommand(object source, System.Web.UI.WebControls.DataGridCommandEventArgs e)
		{
			((DataGrid)source).EditItemIndex = -1;
			DataBind();
		}
		#endregion
		
		private void button1_Click(object sender, System.EventArgs e)
		{
			Order order;
			OrderItem item;
			order = new Order(EcoSpace);
			order.Customer = "Eco Group";
			order.ShippingAddress = "100 Eco road";
			item = new OrderItem(EcoSpace);
			item.Order = order;
			item.Product = "PaperClip";
			item.Quantity = 10000;
			item.Price = 0.01;

			item = new OrderItem(EcoSpace);
			item.Order = order;
			item.Product = "Saab 9.3 Turbo";
			item.Quantity = 1;
			item.Price = 20000;

			item = new OrderItem(EcoSpace);
			item.Order = order;
			item.Product = "Big Mac";
			item.Quantity = 5;
			item.Price = 2;

			order = new Order(EcoSpace);
			order.Customer = "Compiler Group";
			order.ShippingAddress = "50 Drive way";
			item = new OrderItem(EcoSpace);
			item.Order = order;
			item.Product = "Jolt Cola";
			item.Quantity = 100;
			item.Price = 0.59;

			item = new OrderItem(EcoSpace);
			item.Order = order;
			item.Product = "Dell Latitude";
			item.Quantity = 1;
			item.Price = 1243;

			item = new OrderItem(EcoSpace);
			item.Order = order;
			item.Product = "TP cable";
			item.Quantity = 5;
			item.Price = 1.15;

			UpdateDatabase();
			DataBind();
		}
		
		private void button2_Click(object sender, System.EventArgs e)
		{
			Order o = new Order(EcoSpace);
			o.Customer = "New Customer";
			UpdateDatabase();
			Response.Redirect(string.Format("OrderForm.aspx?RootId={0}", IdForObject(o.AsIObject())));
		}
	}
}
